/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.pooladditions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.structurepiececounter.JSONConditionsRegistry;
import com.telepathicgrunt.repurposedstructures.mixin.structures.ListPoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructurePoolAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructureTemplateManagerAccessor;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3485;
import net.minecraft.class_3781;
import net.minecraft.class_3782;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5455;
import net.minecraft.class_6903;

public final class PoolAdditionMerger {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().create();
    private static final String DATA_TYPE = "pool_additions";
    private static final int FILE_SUFFIX_LENGTH = ".json".length();

    private PoolAdditionMerger() {
    }

    public static void mergeAdditionPools() {
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            class_3300 resourceManager = ((StructureTemplateManagerAccessor)minecraftServer.method_27727()).repurposedstructures_getResourceManager();
            Map<class_2960, List<JsonElement>> poolAdditionJSON = GeneralUtils.getAllDatapacksJSONElement(resourceManager, GSON, DATA_TYPE, FILE_SUFFIX_LENGTH);
            PoolAdditionMerger.parsePoolsAndBeginMerger(poolAdditionJSON, (class_5455)minecraftServer.method_30611(), minecraftServer.method_27727());
        });
    }

    private static void parsePoolsAndBeginMerger(Map<class_2960, List<JsonElement>> poolAdditionJSON, class_5455 dynamicRegistryManager, class_3485 structureTemplateManager) {
        class_2378 poolRegistry = dynamicRegistryManager.method_33309(class_2378.field_25917);
        class_6903 customRegistryOps = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)dynamicRegistryManager);
        for (Map.Entry<class_2960, List<JsonElement>> entry : poolAdditionJSON.entrySet()) {
            if (poolRegistry.method_10223(entry.getKey()) == null) continue;
            for (JsonElement jsonElement : entry.getValue()) {
                try {
                    AdditionalStructureTemplatePool.DIRECT_CODEC.parse((DynamicOps)customRegistryOps, (Object)jsonElement).resultOrPartial(messageString -> PoolAdditionMerger.logBadData((class_2960)entry.getKey(), messageString)).ifPresent(validPool -> PoolAdditionMerger.mergeIntoExistingPool(validPool, (class_3785)poolRegistry.method_10223((class_2960)entry.getKey()), structureTemplateManager));
                }
                catch (Exception e) {
                    RepurposedStructures.LOGGER.error("\nRepurposed Structures: Pool Addition json failed to be parsed.\nThis is usually due to using a mod compat datapack without the other mod being on.\nEntry failed to be resolved: %s\nRegistry being used: %s\nError message is: %s".formatted(entry.getKey(), poolRegistry, e.getMessage()).indent(1));
                }
            }
        }
    }

    private static void mergeIntoExistingPool(AdditionalStructureTemplatePool feedingPool, class_3785 gluttonyPool, class_3485 structureTemplateManager) {
        ObjectArrayList elements = new ObjectArrayList(((StructurePoolAccessor)gluttonyPool).repurposedstructures_getTemplates());
        ArrayList<Pair<class_3784, Integer>> elementCounts = new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)gluttonyPool).repurposedstructures_getRawTemplates());
        elements.addAll(((StructurePoolAccessor)((Object)feedingPool)).repurposedstructures_getTemplates());
        elementCounts.addAll(((StructurePoolAccessor)((Object)feedingPool)).repurposedstructures_getRawTemplates());
        for (class_3784 element : elements) {
            if (element instanceof class_3781) {
                class_3781 singlePoolElement = (class_3781)element;
                Optional pieceRL = ((SinglePoolElementAccessor)singlePoolElement).repurposedstructures_getTemplate().left();
                if (pieceRL.isEmpty()) continue;
                PoolAdditionMerger.checkIfPieceExists(feedingPool, structureTemplateManager, (class_2960)pieceRL.get());
                continue;
            }
            if (!(element instanceof class_3782)) continue;
            class_3782 listPoolElement = (class_3782)element;
            for (class_3784 listElement : ((ListPoolElementAccessor)listPoolElement).repurposedstructures_getElements()) {
                class_3781 singlePoolElement;
                Optional pieceRL;
                if (!(listElement instanceof class_3781) || (pieceRL = ((SinglePoolElementAccessor)(singlePoolElement = (class_3781)listElement)).repurposedstructures_getTemplate().left()).isEmpty()) continue;
                PoolAdditionMerger.checkIfPieceExists(feedingPool, structureTemplateManager, (class_2960)pieceRL.get());
            }
        }
        ((StructurePoolAccessor)gluttonyPool).repurposedstructures_setTemplates((ObjectArrayList<class_3784>)elements);
        ((StructurePoolAccessor)gluttonyPool).repurposedstructures_setRawTemplates(elementCounts);
    }

    private static void checkIfPieceExists(AdditionalStructureTemplatePool feedingPool, class_3485 structureTemplateManager, class_2960 pieceRL) {
        class_2960 resourcelocation = new class_2960(pieceRL.method_12836(), "structures/" + pieceRL.method_12832() + ".nbt");
        try {
            InputStream inputstream = ((StructureTemplateManagerAccessor)structureTemplateManager).repurposedstructures_getResourceManager().open(resourcelocation);
            if (inputstream.available() == 0 || inputstream.read(new byte[1]) == -1) {
                RepurposedStructures.LOGGER.error("(Repurposed Structures POOL MERGER) Found an entry in {} that points to the non-existent nbt file called {}", (Object)feedingPool.method_16629(), (Object)pieceRL);
            }
            inputstream.close();
        }
        catch (Throwable filenotfoundexception) {
            RepurposedStructures.LOGGER.error("(Repurposed Structures POOL MERGER) Found an entry in {} that points to the non-existent nbt file called {}", (Object)feedingPool.method_16629(), (Object)pieceRL);
        }
    }

    private static void logBadData(class_2960 poolPath, String messageString) {
        RepurposedStructures.LOGGER.error("(Repurposed Structures POOL MERGER) Failed to parse {} additions file. Error is: {}", (Object)poolPath, (Object)messageString);
    }

    private static class AdditionalStructureTemplatePool
    extends class_3785 {
        private static final Codec<ExpandedPoolEntry> EXPANDED_POOL_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3784.field_24953.fieldOf("element").forGetter(ExpandedPoolEntry::poolElement), (App)Codec.intRange((int)1, (int)5000).fieldOf("weight").forGetter(ExpandedPoolEntry::weight), (App)class_2960.field_25139.optionalFieldOf("condition").forGetter(ExpandedPoolEntry::condition)).apply((Applicative)instance, ExpandedPoolEntry::new));
        public static final Codec<AdditionalStructureTemplatePool> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("name").forGetter(class_3785::method_16629), (App)class_2960.field_25139.fieldOf("fallback").forGetter(class_3785::method_16634), (App)EXPANDED_POOL_ENTRY_CODEC.listOf().fieldOf("elements").forGetter(structureTemplatePool -> structureTemplatePool.rawTemplatesWithConditions)).apply((Applicative)instance, AdditionalStructureTemplatePool::new));
        protected final List<ExpandedPoolEntry> rawTemplatesWithConditions;

        public AdditionalStructureTemplatePool(class_2960 resourceLocation, class_2960 resourceLocation2, List<ExpandedPoolEntry> rawTemplatesWithConditions) {
            super(resourceLocation, resourceLocation2, rawTemplatesWithConditions.stream().filter(triple -> {
                if (triple.condition().isPresent()) {
                    Optional optionalSupplier = JSONConditionsRegistry.RS_JSON_CONDITIONS_REGISTRY.method_17966(triple.condition.get());
                    if (optionalSupplier.isPresent()) {
                        return (Boolean)((Supplier)optionalSupplier.get()).get();
                    }
                    RepurposedStructures.LOGGER.error("Repurposed Structures Error: Found {} entry has a condition that does not exist. Extra info: {}", (Object)resourceLocation, (Object)resourceLocation2);
                }
                return true;
            }).map(triple -> Pair.of((Object)triple.poolElement(), (Object)triple.weight())).collect(Collectors.toList()));
            this.rawTemplatesWithConditions = rawTemplatesWithConditions;
        }

        public record ExpandedPoolEntry(class_3784 poolElement, Integer weight, Optional<class_2960> condition) {
        }
    }
}

